#!/usr/bin/perl -w

# Copyright 2003, Martijn van Oosterhout <kleptog@svana.org>
# Processes the files resulting from SnoopyPro into a nicely readable format. Not extensively tested.
# You may use this code as you wish, no warrenty included.

# out down has data
# out up does not
# in down has no data (except BULK_OR_INTERRUPT_TRANSFER)
# in up has data

use Data::Dumper;
use strict;

require 'parse-hp5400.pl';

my $line = <>;

my $state = 0;
my $done = 0;
my ($dir,$pkt,$id);

my @cap;

while( not $done )
{
  chomp $line;
  chop $line;
  if( $state == 0 )
  {
    if( $line =~ /^\d+\t/ )     # init
    {
      my($x,$time,$msg);

      ( $id,$dir,$x,$time,$msg ) = split /\t/, $line;
      my $io;
      ($io,$dir) = split / /,$dir;

      $cap[$id]{dir} = $io;
      $cap[$id]{$dir}{time} = $time;
      $cap[$id]{type} = $msg;

#      print ">>> $time\t$id\t$dir\t$msg\n";
      if( $msg !~ /^(VENDOR_DEVICE|CONTROL_TRANSFER)$/ )
      {
        $state = 100;
        next;
      }
      $state = 1;
      next;
    }
  }
  if( $state == 1 )
  {
    if( $line =~ /^(SetupPacket|TransferBuffer):/ )
    {
#      print $line,"\n";
      $pkt = $1;
    }
    elsif( $line =~ /^[0-9a-fA-F]{4}:/ )
    {
      my @a = map { hex } split / /, substr( $line, 6 );
      my $off = hex( substr( $line, 0, 4 ) );
#      print substr( $line, 0, 6 ).join(" ",map { sprintf("%02X",$_) } @a)." ".join("",map { (($_&0x7f)<32)?'.':chr($_) } @a)."\n";
      @{ $cap[$id]{$dir}{$pkt} }[$off..$off+$#a] = @a;
    }
    elsif( $line =~ /^\d+\t/ )
    {
      $state = 0;
      redo;
    }
  }
  if( $state == 100 )
  {
    if( $line =~ /^\d+\t/ )
    {
      $state = 0;
      redo;
    }
  }
}
continue
{
  $line = <>;
  $done = not defined($line);
}

#print Dumper( \@cap );

DecodeHP5400( \@cap );
