use strict;

# Copyright 2003, Martijn van Oosterhout <kleptog@svana.org>
# Used by the other parsers to do the processing to make the USB dumps more readable.

sub DecodeHP5400
{
  my $cap = shift;

  for my $i (1..$#$cap)
  {
    my ($x,$code);

    if( not defined $cap->[$i]{dir} )
    {
      print "$i\t<no direction given>\n";
      next;
    }

    if( $cap->[$i]{dir} eq 'in' )
    {
      $x = $cap->[$i]{up};
      $code = 'R';
    }
    elsif( $cap->[$i]{dir} eq 'out' )
    {
      $x = $cap->[$i]{down};
      $code = 'W';
#      print "$i\t$cap->[$i]{down}{time}\t".join(" ",map{sprintf "%02X",$_}@{$cap->[$i]{down}{SetupPacket}})."\tW\t".join(" ",map{sprintf "%02X",$_}@{$cap->[$i]{down}{TransferBuffer}})."\n";
    }
    else
    {
      $code = '???';
      $x = { time => '0.000' };
    }
    print "$i\t$x->{time}\t";
    if( defined $x->{SetupPacket} )
    {
      print join(" ",map{sprintf "%02X",$_}@{$x->{SetupPacket}});
    }
    else
    {
      print "<none given>";
    }
    print "\t$code".(($cap->[$i]{type} =~ /BULK/)?'(bulk)':'')."\t";

    if( $cap->[$i]{type} =~ /BULK/ )
    {
      print $x->{TransferBuffer},"\n";
    }
    else
    {
      print join(" ",map{sprintf "%02X",$_}@{$x->{TransferBuffer}})."\n";
    }

    if( $code eq "W" and defined($x->{SetupPacket}) and $x->{SetupPacket}[3] == 0x25 )
    {
      printf "-- Set scan settings: unknown=%02X, dpi-xy=(%d,%d), off-xy=(%d,%d)(%.2fcm,%.2fcm), res-xy=(%d,%d)(%.2fcm,%.2fcm), unknown=(%04X,%04X,%04X)\n",
         $x->{TransferBuffer}[0],
         $x->{TransferBuffer}[1]*256 + $x->{TransferBuffer}[2],
         $x->{TransferBuffer}[3]*256 + $x->{TransferBuffer}[4],

         $x->{TransferBuffer}[5]*256 + $x->{TransferBuffer}[6],
         $x->{TransferBuffer}[7]*256 + $x->{TransferBuffer}[8],
         ($x->{TransferBuffer}[5]*256 + $x->{TransferBuffer}[6])*2.54/300,
         ($x->{TransferBuffer}[7]*256 + $x->{TransferBuffer}[8])*2.54/300,
#         $x->{TransferBuffer}[5]*0x1000000 + $x->{TransferBuffer}[6]*0x10000 + $x->{TransferBuffer}[7]*256 + $x->{TransferBuffer}[8],

         $x->{TransferBuffer}[9]*256 + $x->{TransferBuffer}[10],
         $x->{TransferBuffer}[11]*256 + $x->{TransferBuffer}[12],
         ($x->{TransferBuffer}[9]*256 + $x->{TransferBuffer}[10])*2.54/300,
         ($x->{TransferBuffer}[11]*256 + $x->{TransferBuffer}[12])*2.54/300,

         $x->{TransferBuffer}[13]*256 + $x->{TransferBuffer}[14],
         $x->{TransferBuffer}[15]*256 + $x->{TransferBuffer}[16],
         $x->{TransferBuffer}[17]*256 + $x->{TransferBuffer}[18],
         $x->{TransferBuffer}[19]*256 + $x->{TransferBuffer}[20];
    }
    if( $code eq "R" and defined($x->{SetupPacket}) and $x->{SetupPacket}[3] == 0x34 )
    {
      printf "-- Read result info: unknown=%04X, datalen=%d, zero=%04X, bitmap-xy=(%d,%d), zero=%08X, bpp=%.2f\n",
         $x->{TransferBuffer}[0]*256 + $x->{TransferBuffer}[1],
         $x->{TransferBuffer}[2]*0x1000000 + $x->{TransferBuffer}[3]*0x10000 + $x->{TransferBuffer}[4]*256 + $x->{TransferBuffer}[5],

         $x->{TransferBuffer}[6]*256 + $x->{TransferBuffer}[7],

         $x->{TransferBuffer}[8]*256 + $x->{TransferBuffer}[9],
         $x->{TransferBuffer}[10]*256 + $x->{TransferBuffer}[11],

         $x->{TransferBuffer}[12]*0x1000000 + $x->{TransferBuffer}[13]*0x10000 + $x->{TransferBuffer}[14]*256 + $x->{TransferBuffer}[15],

         ($x->{TransferBuffer}[2]*0x1000000 + $x->{TransferBuffer}[3]*0x10000 + $x->{TransferBuffer}[4]*256 + $x->{TransferBuffer}[5])*8.0/
             ( ($x->{TransferBuffer}[8]*256 + $x->{TransferBuffer}[9]) * ($x->{TransferBuffer}[10]*256 + $x->{TransferBuffer}[11]) );
    }
  }
}

1;
