#!/usr/bin/perl -w

use strict;
use Data::Dumper;

# Copyright 2003, Martijn van Oosterhout <kleptog@svana.org>
# Processes the files resulting from UsbSnoop into a nicely readable format.
# You may use this code as you wish, no warrenty included.

require 'parse-hp5400.pl';

my(%hash,$dir,@cap);

while(<>)
{
  next unless /^\d{8} /;

  tr/\r\n//d;

  my($row,$time,$str) = split / +/,$_,3;

  next if $str =~ /^UsbSnoop /;
  next if $str =~ /^\s*$/;

#  print $str,"\n";

  if( $str =~ /^[<>]{7} URB (\d+) ([\w ]+)\.\.\./ )
  {
    Process(\%hash) if scalar(keys %hash);
    $dir = ($2 eq "going down")?"down":"up";
    %hash = ('dir' => $dir, 'time' => $time, data => [], id => $1 );
#    print "Start Packet $1\n";
  }

  if( $str =~ /^-- URB_(\w+)/ )
  {
    $hash{type} = $1;
  }

  if( $str =~ /^(\w+)\s+[:=] (.+)/ )
  {
    $hash{$1} = $2;
  }

  if( $str =~ /^([0-9a-fA-F]{4}):/ )
  {
    # We used to ignore this offset but since the debug output had a
    # tendancy to drop stuff, we needed this to ensure data got to the right
    # place.
    $hash{offset} = hex($1);
  }

  if( $str =~ /^[0-9a-fA-F ]+$/ )
  {
    my @a = map { hex } split / /, $str;
    @{ $hash{data} }[$hash{offset} .. $hash{offset}+$#a] = @a;
#    splice @{ $hash{data} }, $hash{offset}, $#a, @a;
  }
}

#print Dumper(\@cap);

DecodeHP5400( \@cap );

sub Process
{
  my $hash = shift;

#  print Dumper($hash);

  return if not defined $hash->{TransferFlags};

  return if( $hash->{TransferFlags} !~ /DIRECTION_(IN|OUT)/ );

  my $id = $hash->{id};

  $cap[$id]{type} = $hash->{type};
  $cap[$id]{dir} = lc($1);

  return if $hash->{type} !~ /VENDOR_DEVICE|CONTROL_TRANSFER|BULK_OR_INTERRUPT_TRANSFER/;

  my $dir = $hash->{dir};   # up or down

  if( defined $hash->{SetupPacket} )
  {
    $cap[$id]{$dir}{SetupPacket} = [ map {hex} split / /, $hash->{SetupPacket} ];
  }
  elsif( defined $hash->{Request} )
  {
    my $a = pack( "CCSS", map{hex} ( $hash->{RequestTypeReservedBits},
                                      $hash->{Request},
                                      $hash->{Value},
                                      $hash->{Index} ) );

    # Need to reverse the Value and Index fields to fix the byte order
    $cap[$id]{$dir}{SetupPacket} = [ unpack( "C*", $a ) ];
  }

  # Fill up the array if we lost/skipped data
  if( defined $hash->{TransferBufferLength} )
  {
    my $len = hex( $hash->{TransferBufferLength} );

    if( scalar( @{$hash->{data}} ) < $len )
    {
      $hash->{data}[$len-1] = undef;
    }
  }

  if( $hash->{type} =~ /BULK/ )
  {
    $cap[$id]{$dir}{TransferBuffer} = scalar( @{$hash->{data}} )." elements";
  }
  else
  {
    $cap[$id]{$dir}{TransferBuffer} = $hash->{data};
  }
  $cap[$id]{$dir}{time} = $hash->{time};

}
