/*
  Copyright (C) 2003 Martijn van Oosterhout <kleptog@svana.org>
  
  Originally copied from HP3300 testtools. Original notice follows:
  
  Copyright (C) 2001 Bertrik Sikken (bertrik@zonnet.nl)

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  $Id: HP5400.h,v 1.24 2002/11/04 23:48:32 bertrik Exp $
*/

/*
    Core HP5400 functions.
*/


#ifndef _HP5400_H_
#define _HP5400_H_

#include <unistd.h>

//#include "mytypes.h"
#include "hp5400_xfer.h"   /* for EScannerModel */

//#define HP5400_RIGHT  330
//#define HP5400_TOP    452
//#define HP5400_BOTTOM (HP5400_TOP + 14200UL)

#define HW_PIXELS   2690    /* number of pixels supported by hardware */
#define HW_DPI      300     /* horizontal resolution of hardware */
#define HW_LPI      300    /* vertical resolution of hardware */

/* In case we ever need to track multiple models */
typedef struct {
  char *pszVendor;
  char *pszName;
} TScannerModel;

typedef struct {
  /* transfer buffer */
  void  *buffer;              /* Pointer to memory allocated for buffer */
  int   roff, goff, boff;     /* Offset into buffer of rows to be copied *next* */
  int   bufstart, bufend;     /* What is currently the valid buffer */
  int   bpp;                  /* How many lines to go */
  int   linelength, pixels;   /* Bytes per line from scanner */
  int   blksize;              /* Size of blocks to pull from scanner */
} TDataPipe;

typedef struct {
  int           iXferHandle;    /* handle used for data transfer to HW */
  TDataPipe     pipe;           /* Pipe for data */
  
  int           iTopLeftX;      /* in mm */
  int           iTopLeftY;      /* in mm */
/*  int           iSensorSkew;   */ /* in units of 1/1200 inch */
/*  int           iSkipLines;    */ /* lines of garbage to skip */
/*  int           fReg07;        */ /* NIASH00019 */
/*  int           fGamma16;      */ /* if TRUE, gamma entries are 16 bit */
/*  int           iExpTime;      */
/*  int           iReversedHead; */ /* Head is reversed */
/*  int           iBufferSize;   */ /* Size of internal scan buffer */
/*  EScannerModel eModel;        */
} THWParams;


typedef struct {
  int   iDpi;         /* horizontal resolution */
  int   iLpi;         /* vertical resolution */
  int   iTop;         /* in HW coordinates (units HW_LPI) */
  int   iLeft;        /* in HW coordinates (units HW_LPI) */
  int   iWidth;       /* in HW coordinates (units HW_LPI) */
  int   iHeight;      /* in HW coordinates (units HW_LPI) */
//  int   iBottom;

  int   iBytesPerLine;   /* Resulting bytes per line */
  int   iLines;          /* Resulting lines of image */
} TScanParams;


int   HP5400Open(THWParams *pHWParams, char *pszName);
void  HP5400Close(THWParams *pHWParams);

void  DumpHex(void *pabData, int iLen, int iWidth);

//void  ScanLines(FILE *pFile, TScanParams *pParams, THWParams *pHWParams);
//int   SimpleCalib(THWParams *pHWPar, int *pabCalibTable);

//int   GetLamp(THWParams *pHWParams, int  *pfLampIsOn);
//int   SetLamp(THWParams *pHWParams, int  fLampOn);

//int   InitScan(TScanParams *pParams, THWParams *pHWParams);
//void  FinishScan(THWParams *pHWParams);

//void  CalcGamma(int *pabTable, double Gamma);
void  WriteGammaCalibTable( int iHandle, const int *pabGammaR, const int *pabGammaG, const int *pabGammaB );

void  CircBufferInit(int iHandle, TDataPipe *p, int iBytesPerLine,
                     int bpp, int iMisAlignment, int blksize);
void  CircBufferGetLine(int iHandle, TDataPipe *p, void *pabLine );
void  CircBufferExit(TDataPipe *p);

int HP5400Detect( char *filename, int (*_ReportDevice)(TScannerModel *pModel, char *pszDeviceName) );

#endif /* NO _HP5400_H_ */

