#!/usr/bin/perl -w

use BarCode;

# Test function to check the Reed-Solomon codes and check the output.
sub Test
{
  # Tests from Australia Post documentation
  my @tests = ( [ '11', '39987520', [ 50, 25, 52, 50 ] ],
                [ '11', '67671415', [ 35, 61, 29, 12 ] ],
                [ '11', '48487312', [ 57, 13, 12, 25 ] ],
                [ '11', '35797531', [ 36, 11, 25,  2 ] ] );

  open( OUT, ">/tmp/a.ps" ) || die;

  print OUT "%!PS-Adobe-3.0\n";
  print OUT "initgraphics\n100 600 translate\n";

  foreach my $test (@tests)
  {
    my( $type, $dpid, $res ) = @$test;

    my $val = ConvertTypeN($type) . ConvertTypeN( $dpid ) . "3";

    my @syms = map { my $v = 0; map { $v = $v*4 + $_ } split //; $v } grep { length } split /(...)/, $val;

    print "$dpid => $val => ".join(",",@syms)." => ".join(",",ReedSolomon::Encode(@syms))."\n";

    my $bc = new BarCode;
    $bc->setType("11");
    $bc->setDPID($dpid);
    print $bc->outputString,"\n";

    print OUT "0 -100 translate\n";
    print OUT $bc->outputPS;
  }
}

Test();

