/*
 * Proxy Thread for OpenGate
 * 
 * Copyright (c) Marco Polci
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * $Log: ProxyThread.h,v $
 * Revision 1.6  2000/12/22 12:12:27  mpolci
 * Modified H245Thread_Proxy::AdmissibleIP. Now the admissible ip can be either
 * the RAS and the call signal address. Before this modification if the RAS address
 * was present the call signal address was not considered valid.
 *
 * Revision 1.5  2000/12/01 10:18:07  mpolci
 * Added support for multihomed enviroment.
 * Added the metod H245Thread_Proxy::GetLocalAddress().
 *
 * Revision 1.4  2000/10/25 15:25:25  mpolci
 * Security Fix. Now check the port number used for T.120 channel. Accept only non system
 * ports (over 1024). Added metod H245Thread_Proxy::AdmissiblePort()
 *
 * Revision 1.3  2000/10/25 13:34:02  mpolci
 * Security Fix. Added some checks on IP addresses. Now the  store the
 * CallDetails and check the ip addresses of the opened T.120 channel.
 * Modifications:
 * - H245Thread_Proxy (class declaration)
 * - H245Thread_Proxy::MyCall (new member data)
 * - H245Thread_Proxy::AdmissibleIP () (new metod)
 * - H245Thread_Proxy::H245Thread_Proxy()
 * - H245Thread_Proxy::HandleOpenLogicalChannel()
 * - H245Thread_Proxy::handleT120Ack()
 * - H245Thread_Proxy::HandleOpenLogicalChannelConfirm() (removed unused variable warning)
 *
 * Revision 1.2  2000/10/17 13:00:13  mpolci
 * File header and CVS log entry setup
 *
 *
 * Revision 1.0  2000/09/05 14:08
 * Initial revision
 *
 */

#include "CallThread.h"
#include "ProxyTabl.h"

class H245Thread_Proxy : public H245Thread
{
    PCLASSINFO(H245Thread_Proxy, H245Thread);
public:
    H245Thread_Proxy( CallThread *                    Parent,
                      const Environ &                 AkaEnviron,
                      const H225_TransportAddress &   CalledAddress,
                      const CallDetails &             MyCallDetails
                    );
    virtual ~H245Thread_Proxy();

protected:
    virtual void HandleRequest( H245_RequestMessage & Request, bool FromCaller );
    // Task: to handle the given H.245 request

    virtual void HandleResponse( H245_ResponseMessage & Response, bool FromCaller );
    // Task: to handle the given H.245 response

    virtual void HandleIndication( H245_IndicationMessage & Indication, bool FromCaller );
    // Task: to handle the given H.245 indication

    virtual void HandleOpenLogicalChannel( H245_OpenLogicalChannel & msg, bool FromCaller );
    virtual void HandleOpenLogicalChannelAck( H245_OpenLogicalChannelAck & msg, bool FromCaller );
    virtual void HandleOpenLogicalChannelConfirm( H245_OpenLogicalChannelConfirm & msg, bool FromCaller );
    virtual void HandleOpenLogicalChannelReject( H245_OpenLogicalChannelReject & msg, bool FromCaller );
    virtual void HandleCloseLogicalChannel( H245_CloseLogicalChannel & msg, bool FromCaller );

    ProxyTable proxy_media_channels,
               proxy_control_channels,
               proxy_t120_channels;

    CallDetails MyCall;

    PIPSocket::Address GetLocalAddress(bool CallerSide);
    // Task: return the address of the interface to the caller host or the called host.

private:
    BOOL handleOpenRTP( H245_TransportAddress &           Addr,
                        const H245_LogicalChannelNumber & flcNum,
                        bool                              FromCaller,
                        bool                              fControlChannel
                      );

    BOOL handleRTPAck( H245_TransportAddress &           Addr, 
                       const H245_LogicalChannelNumber & flcNum, 
                       bool                              FromCaller,
                       ProxyTable &                      proxy_channels
                     );

    BOOL handleT120Ack( H245_TransportAddress &           Addr, 
                        const H245_LogicalChannelNumber & flcNum, 
                        bool                              FromCaller
                      );

    void deleteChannel( const H245_LogicalChannelNumber & flcNum,
                        bool                              FromCaller
                      );

    bool AdmissibleIP(bool caller, PIPSocket::Address & ip);
    // Task: Used on logical channel procedures to check if the ip address used
    //       for the logical channel is admissible. The admissible ips are the
    //       ip used for RAS addresses or the ip of the call signal addresses
    //       of the indicated endpoint (caller or called).
    //       If the endpoint is not registered, the given address is ammissible
    //       only if the endpoint id is the bogus id and the ip is external to
    //       the network covered by the proxy.

    bool AdmissiblePort( WORD port );
    // Task: Used on open logical channel procedures to check if the port number
    //       used for the logical channel is admissible. Only non system ports
    //       are admissible.

};
