/*
 * RouteTable for OpenH323Proxy
 * 
 * Copyright (c) Marco Polci
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * $Log: RouteTbl.h,v $
 * Revision 1.3  2000/12/05 17:17:45  mpolci
 * Added some comments and removed some log message.
 *
 * Revision 1.2  2000/12/01 11:32:29  mpolci
 * Added the const qualifier to the metod RouteTbl::GetLocalAddress()
 *
 * Revision 1.1  2000/11/28 12:01:58  mpolci
 * Initial revision.
 * Definition of the class RouteTbl. The class stores the route table of
 * the host running the proxy. The main utilization is to obtain the local
 * address visible from a specified host. This is to resolve the multi-homed
 * enviroment problems.
 *
 *
 */
#ifndef _ROUTETBL_H
#define _ROUTETBL_H

#include <ptlib.h>
#include <ptlib/svcproc.h>
#include <ptlib/sockets.h>

// class RouteTbl: this class store the routing table of the host running
// the proxy. It's used to find a local address visible from a specified
// address.
class RouteTbl {
public:
    RouteTbl();
    ~RouteTbl();

    PIPSocket::Address GetLocalAddress() const { return localAddr; };
    // Task: to get the local address associated to the default gateway's interface.

    PIPSocket::Address GetLocalAddress(PIPSocket::Address addr) const;
    // Task: to get the local address associated to the interface used to route the
    //       specified address.

private:
    class TblEntry: public PObject {
        PCLASSINFO(TblEntry, PObject);      
    public:
        PIPSocket::Address network,
	                   net_mask,
	                   local_addr;
        TblEntry( PIPSocket::Address net,
                  PIPSocket::Address nm,
                  PIPSocket::Address laddr
                ) : network(net), net_mask(nm), local_addr(laddr) {};
        virtual ~TblEntry() {/*  PSYSTEMLOG(Info, "TblEntry::~TblEntry()");*/ };
    };
    PLIST(Table, TblEntry);

    Table table;
    PIPSocket::Address localAddr;  // Local address associated to the default gateway's interface

    void initTable();
};

#endif
