/*
 * Proxy criteria for OpenGate
 * 
 * Copyright (c) Marco Polci
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * $Log: ProxyCriteria.cxx,v $
 * Revision 1.2  2000/10/17 13:00:13  mpolci
 * File header and CVS log entry setup
 *
 *
 * Revision 1.0  2000/09/04 10:33
 * Initial revision
 *
 */

#include <ptlib.h>
#include <ptlib/svcproc.h>
#include "ProxyCriteria.h"

void ProxyCriteria::loadConfiguration( const PConfig & cfg )
{
   fProxyEnabled = cfg.GetBoolean( "Proxy", "Proxy Enabled", FALSE );
   PString addr, mask;
   addr = cfg.GetString( "Proxy", "Internal Network Address", "127.0.0.1");
   mask = cfg.GetString( "Proxy", "Internal Network Mask", "255.255.255.255" );
   PSYSTEMLOG( Info, "Proxy enabled = " << fProxyEnabled << " addr = " << addr << " mask = " << mask );
   netaddress = PIPSocket::Address( addr );
   netmask = PIPSocket::Address( mask );
   PSYSTEMLOG( Info, netaddress << "/" << netmask );
}

BOOL ProxyCriteria::proxyRequired( PIPSocket::Address ip1, PIPSocket::Address ip2 ) const
// Task: to check if the proxy must be enabled to allow comunications between these ip addresses.
{
   if ( fProxyEnabled ) {
      BOOL ip1internal = ( (ip1 & netmask) == netaddress ),
           ip2internal = ( (ip2 & netmask) == netaddress );
      return (ip1internal && !ip2internal) || (!ip1internal && ip2internal);
   } else 
      return FALSE;
}
