/*
 * Proxy criteria for OpenGate
 * 
 * Copyright (c) Marco Polci
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * $Log: ProxyCriteria.h,v $
 * Revision 1.3  2000/10/25 10:06:49  mpolci
 * Added the metod ProxyCriteria::isInternal()
 *
 * Revision 1.2  2000/10/17 13:00:13  mpolci
 * File header and CVS log entry setup
 *
 *
 * Revision 1.0  2000/09/04 10:33
 * Initial revision
 *
 */
#ifndef _PROXYCRITERIA_H
#define _PROXYCRITERIA_H

#include <ptlib.h>
#include <ptlib/sockets.h>

class ProxyCriteria {
public:
   void loadConfiguration(const PConfig &);

   BOOL proxyRequired(PIPSocket::Address ip1, PIPSocket::Address ip2) const;
   // Task: to check if the proxy must be enabled to allow comunications between these ip addresses.

   BOOL isInternal(PIPSocket::Address ip) const
       { return (ip & netmask) == netaddress; };
   // Task: return true if the given ip belongs to the network covered by the proxy.
protected:
   BOOL fProxyEnabled;
   // Network address and mask of internal network. 
   PIPSocket::Address netaddress,
                      netmask;
};

#endif

