/*
 * Ras server for OpenGate
 * 
 * Copyright (c) Egoboo Ltd. 1999-2000
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Open Gatekeeper
 *
 * The Initial Developer of the Original Code is Egoboo Ltd.
 *
 * $Log: RasServer.h,v $
 * Revision 1.8  2000/05/12 14:02:37  aunitt
 * Renamed PRasLog to Log
 *
 * Revision 1.7  2000/05/10 09:13:49  aunitt
 * Remove bogus comment.
 *
 * Revision 1.6  2000/04/27 17:49:06  aunitt
 * Added support for creation of new messages to support registration timeout
 * handling.
 *
 * Revision 1.5  2000/04/20 18:44:49  aunitt
 * Added parameter to signify if we are handling a multicast request.
 * LRQs do different things with multicast.
 *
 * Revision 1.4  2000/04/10 19:12:49  aunitt
 * Moved environment data into new environment object to tidy things up.
 *
 * Revision 1.3  2000/04/05 15:15:48  aunitt
 * Added RasLog object.
 *
 * Revision 1.2  2000/02/27 20:45:15  aunitt
 * Fixed problems with replying to wrong RAS address
 *
 * Revision 1.1.1.1  2000/02/01 22:25:34  aunitt
 * Initial revision
 *
 *
 */

#ifndef _RASSERVER_H
#define _RASSERVER_H

#include <ptlib.h>
#include <h225.h>
#include "Environ.h"
#include "EndpointTabl.h"
#include "CallTabl.h"

class RasServer
{
	public:
		RasServer( const Environ & MyEnviron,
	                     WORD      Port
		         );

		virtual ~RasServer();

		BOOL HandleRasRequest( const H225_RasMessage &       Request,
		                             bool                    IsMulticast,
	        	                     H225_RasMessage &       Reply,
	        	                     H225_TransportAddress & ReplyTo
		        	     );
		// Task: to handle the given Ras request

		void MakeUnregMessage( const Endpoint &        EP,
		                             H225_RasMessage & Mesg
		                     );
		// Task: to construct an unregistration request for the given endpoint -
		//       used when we are unregistering all endpoints
		
		void MakeUnregMessage( const Endpoint &                 EP,
                               const H225_UnregRequestReason &  Reason,
                                     H225_RasMessage &          Mesg
		                     );
        // Task: to construct an unregistration request for the given endpoint
		
        void MakeIRR( const H225_CallReferenceValue &   CRV,
                      const H225_TransportAddress &     SendTo,
                            H225_RasMessage &           Mesg
		            );
		// Task: to construct an IRR request for the given call
	
	protected:
		RasServer();	// Disallow default constructor		

		const Environ &         MyEnviron;
		//H225_TransportAddress   GatekeeperAddr;
        WORD RASPort;

        H225_TransportAddress GetGatekeeperAddr(const H225_TransportAddress & Destination);
        // Task: to return the gatekeeper address visible from specified Destination address.
};

#endif // _RASSERVER_H
