set client_min_messages = fatal;

set search_path = taggedtypes, public;

set client_encoding=latin9;

DROP TYPE currency CASCADE;
DROP TYPE currencyint CASCADE;
DROP TYPE currencyfloat CASCADE;
DROP TYPE fixed_timestamp CASCADE;
DROP TYPE currency_t CASCADE;
DROP TYPE currencyint_t CASCADE;
DROP TYPE currencyfloat_t CASCADE;
DROP TYPE fixed_timestamp_t CASCADE;
DROP TABLE currencies;
DROP TABLE timezones;
DROP TABLE c;

CREATE TABLE currencies (tag text, format text) WITH OIDS;
CREATE TABLE timezones (tag text) WITH OIDS;

set client_min_messages = error;

copy currencies from stdin;
AUD	"AU$"999990.00
USD	"US$"999990.00
EUR	"  "999990.00
YEN	"   "999990.00""
\.

copy timezones from stdin;
Africa/Abidjan
Africa/Accra
Africa/Addis_Ababa
Africa/Algiers
Africa/Asmera
Africa/Bamako
Africa/Bangui
Africa/Banjul
Africa/Bissau
Africa/Blantyre
Africa/Brazzaville
Africa/Bujumbura
Africa/Cairo
Africa/Casablanca
Africa/Ceuta
Africa/Conakry
Africa/Dakar
Africa/Dar_es_Salaam
Africa/Djibouti
Africa/Douala
Africa/El_Aaiun
Africa/Freetown
Africa/Gaborone
Africa/Harare
Africa/Johannesburg
Africa/Kampala
Africa/Khartoum
Africa/Kigali
Africa/Kinshasa
Africa/Lagos
Africa/Libreville
Africa/Lome
Africa/Luanda
Africa/Lubumbashi
Africa/Lusaka
Africa/Malabo
Africa/Maputo
Africa/Maseru
Africa/Mbabane
Africa/Mogadishu
Africa/Monrovia
Africa/Nairobi
Africa/Ndjamena
Africa/Niamey
Africa/Nouakchott
Africa/Ouagadougou
Africa/Porto-Novo
Africa/Sao_Tome
Africa/Timbuktu
Africa/Tripoli
Africa/Tunis
Africa/Windhoek
America/Adak
America/Anchorage
America/Anguilla
America/Antigua
America/Araguaina
America/Argentina/Buenos_Aires
America/Argentina/Catamarca
America/Argentina/ComodRivadavia
America/Argentina/Cordoba
America/Argentina/Jujuy
America/Argentina/La_Rioja
America/Argentina/Mendoza
America/Argentina/Rio_Gallegos
America/Argentina/San_Juan
America/Argentina/Tucuman
America/Argentina/Ushuaia
America/Aruba
America/Asuncion
America/Bahia
America/Barbados
America/Belem
America/Belize
America/Boa_Vista
America/Bogota
America/Boise
America/Cambridge_Bay
America/Campo_Grande
America/Cancun
America/Caracas
America/Cayenne
America/Cayman
America/Chicago
America/Chihuahua
America/Costa_Rica
America/Cuiaba
America/Curacao
America/Danmarkshavn
America/Dawson
America/Dawson_Creek
America/Denver
America/Detroit
America/Dominica
America/Edmonton
America/Eirunepe
America/El_Salvador
America/Fortaleza
America/Glace_Bay
America/Godthab
America/Goose_Bay
America/Grand_Turk
America/Grenada
America/Guadeloupe
America/Guatemala
America/Guayaquil
America/Guyana
America/Halifax
America/Havana
America/Hermosillo
America/Indiana/Knox
America/Indiana/Marengo
America/Indiana/Vevay
America/Indianapolis
America/Inuvik
America/Iqaluit
America/Jamaica
America/Juneau
America/Kentucky/Monticello
America/La_Paz
America/Lima
America/Los_Angeles
America/Louisville
America/Maceio
America/Managua
America/Manaus
America/Martinique
America/Mazatlan
America/Menominee
America/Merida
America/Mexico_City
America/Miquelon
America/Monterrey
America/Montevideo
America/Montreal
America/Montserrat
America/Nassau
America/New_York
America/Nipigon
America/Nome
America/Noronha
America/North_Dakota/Center
America/Panama
America/Pangnirtung
America/Paramaribo
America/Phoenix
America/Port-au-Prince
America/Port_of_Spain
America/Porto_Velho
America/Puerto_Rico
America/Rainy_River
America/Rankin_Inlet
America/Recife
America/Regina
America/Rio_Branco
America/Santiago
America/Santo_Domingo
America/Sao_Paulo
America/Scoresbysund
America/St_Johns
America/St_Kitts
America/St_Lucia
America/St_Thomas
America/St_Vincent
America/Swift_Current
America/Tegucigalpa
America/Thule
America/Thunder_Bay
America/Tijuana
America/Toronto
America/Tortola
America/Vancouver
America/Whitehorse
America/Winnipeg
America/Yakutat
America/Yellowknife
Antarctica/Casey
Antarctica/Davis
Antarctica/DumontDUrville
Antarctica/Mawson
Antarctica/McMurdo
Antarctica/Palmer
Antarctica/Rothera
Antarctica/Syowa
Antarctica/Vostok
Asia/Aden
Asia/Almaty
Asia/Amman
Asia/Anadyr
Asia/Aqtau
Asia/Aqtobe
Asia/Ashgabat
Asia/Baghdad
Asia/Bahrain
Asia/Baku
Asia/Bangkok
Asia/Beirut
Asia/Bishkek
Asia/Brunei
Asia/Calcutta
Asia/Choibalsan
Asia/Chongqing
Asia/Colombo
Asia/Damascus
Asia/Dhaka
Asia/Dili
Asia/Dubai
Asia/Dushanbe
Asia/Gaza
Asia/Harbin
Asia/Hong_Kong
Asia/Hovd
Asia/Irkutsk
Asia/Jakarta
Asia/Jayapura
Asia/Jerusalem
Asia/Kabul
Asia/Kamchatka
Asia/Karachi
Asia/Kashgar
Asia/Katmandu
Asia/Krasnoyarsk
Asia/Kuala_Lumpur
Asia/Kuching
Asia/Kuwait
Asia/Macau
Asia/Magadan
Asia/Makassar
Asia/Manila
Asia/Muscat
Asia/Nicosia
Asia/Novosibirsk
Asia/Omsk
Asia/Oral
Asia/Phnom_Penh
Asia/Pontianak
Asia/Pyongyang
Asia/Qatar
Asia/Qyzylorda
Asia/Rangoon
Asia/Riyadh
Asia/Riyadh87
Asia/Riyadh88
Asia/Riyadh89
Asia/Saigon
Asia/Sakhalin
Asia/Samarkand
Asia/Seoul
Asia/Shanghai
Asia/Singapore
Asia/Taipei
Asia/Tashkent
Asia/Tbilisi
Asia/Tehran
Asia/Thimphu
Asia/Tokyo
Asia/Ulaanbaatar
Asia/Urumqi
Asia/Vientiane
Asia/Vladivostok
Asia/Yakutsk
Asia/Yekaterinburg
Asia/Yerevan
Atlantic/Azores
Atlantic/Bermuda
Atlantic/Canary
Atlantic/Cape_Verde
Atlantic/Faeroe
Atlantic/Madeira
Atlantic/Reykjavik
Atlantic/South_Georgia
Atlantic/St_Helena
Atlantic/Stanley
Australia/Adelaide
Australia/Brisbane
Australia/Broken_Hill
Australia/Darwin
Australia/Hobart
Australia/Lindeman
Australia/Lord_Howe
Australia/Melbourne
Australia/Perth
Australia/Sydney
CET
EET
Etc/GMT
Etc/GMT+1
Etc/GMT+10
Etc/GMT+11
Etc/GMT+12
Etc/GMT+2
Etc/GMT+3
Etc/GMT+4
Etc/GMT+5
Etc/GMT+6
Etc/GMT+7
Etc/GMT+8
Etc/GMT+9
Etc/GMT-1
Etc/GMT-10
Etc/GMT-11
Etc/GMT-12
Etc/GMT-13
Etc/GMT-14
Etc/GMT-2
Etc/GMT-3
Etc/GMT-4
Etc/GMT-5
Etc/GMT-6
Etc/GMT-7
Etc/GMT-8
Etc/GMT-9
Etc/UCT
Etc/UTC
Europe/Amsterdam
Europe/Andorra
Europe/Athens
Europe/Belfast
Europe/Belgrade
Europe/Berlin
Europe/Brussels
Europe/Bucharest
Europe/Budapest
Europe/Chisinau
Europe/Copenhagen
Europe/Dublin
Europe/Gibraltar
Europe/Helsinki
Europe/Istanbul
Europe/Kaliningrad
Europe/Kiev
Europe/Lisbon
Europe/London
Europe/Luxembourg
Europe/Madrid
Europe/Malta
Europe/Minsk
Europe/Monaco
Europe/Moscow
Europe/Oslo
Europe/Paris
Europe/Prague
Europe/Riga
Europe/Rome
Europe/Samara
Europe/Simferopol
Europe/Sofia
Europe/Stockholm
Europe/Tallinn
Europe/Tirane
Europe/Uzhgorod
Europe/Vaduz
Europe/Vienna
Europe/Vilnius
Europe/Warsaw
Europe/Zaporozhye
Europe/Zurich
Factory
Indian/Antananarivo
Indian/Chagos
Indian/Christmas
Indian/Cocos
Indian/Comoro
Indian/Kerguelen
Indian/Mahe
Indian/Maldives
Indian/Mauritius
Indian/Mayotte
Indian/Reunion
MET
Pacific/Apia
Pacific/Auckland
Pacific/Chatham
Pacific/Easter
Pacific/Efate
Pacific/Enderbury
Pacific/Fakaofo
Pacific/Fiji
Pacific/Funafuti
Pacific/Galapagos
Pacific/Gambier
Pacific/Guadalcanal
Pacific/Guam
Pacific/Honolulu
Pacific/Johnston
Pacific/Kiritimati
Pacific/Kosrae
Pacific/Kwajalein
Pacific/Majuro
Pacific/Marquesas
Pacific/Midway
Pacific/Nauru
Pacific/Niue
Pacific/Norfolk
Pacific/Noumea
Pacific/Pago_Pago
Pacific/Palau
Pacific/Pitcairn
Pacific/Ponape
Pacific/Port_Moresby
Pacific/Rarotonga
Pacific/Saipan
Pacific/Tahiti
Pacific/Tarawa
Pacific/Tongatapu
Pacific/Truk
Pacific/Wake
Pacific/Wallis
Pacific/Yap
WET
\.

SELECT create_tagged_type( 'currency', 'numeric(8,2)', 'currencies' );
SELECT create_tagged_type( 'currencyint', 'integer', 'currencies' );
SELECT create_tagged_type( 'currencyfloat', 'float', 'currencies' );

SELECT create_tagged_type( 'fixed_timestamp', 'timestamptz', 'timezones' );

CREATE TABLE c ( c1 currency, c2 currencyint, c3 currencyfloat, t fixed_timestamp );

copy c from stdin;
232.44 USD	33 AUD	12 EUR	2005-08-14 0:0:0+0 Europe/Amsterdam
21.2 EUR	2 EUR	14 USD	2005-08-14 0:0:0+0 Australia/Sydney
-13.4444 AUD	-2 USD	-200 AUD	2005-08-14 0:0:0+0 Asia/Hong_Kong
0.01 USD	2 AUD	23 USD	2005-08-14 0:0:0+0 America/New_York
14.00 AUD	12 USD	1 USD	2005-08-14 0:0:0+0 Asia/Kuwait
\.

CREATE FUNCTION "timestamp"(fixed_timestamp_t) RETURNS "timestamp" 
as 'SELECT $1.value at time zone $1.tag' 
LANGUAGE 'sql' STRICT IMMUTABLE;

CREATE FUNCTION print_currency( currency ) RETURNS text 
AS 'SELECT to_char( value($1), (tagdata($1)).format )' 
LANGUAGE 'sql' STRICT STABLE;

select create_tagged_operator( 'currency','*','numeric' ,'currency');
select create_tagged_operator( 'numeric', '*','currency','currency');
select create_tagged_operator( 'currency','/','currency','numeric' );
select create_tagged_operator( 'currency','/','numeric' ,'currency' );
select create_tagged_operator( 'currency','+','currency','currency');
select create_tagged_operator( 'currency','-','currency','currency');

--select create_tagged_operator( 'currencyint','*','integer'    ,'currencyint');
--select create_tagged_operator( 'integer',    '*','currencyint','currencyint');
--select create_tagged_operator( 'currencyint','/','currencyint','integer'    );
--select create_tagged_operator( 'currencyint','+','currencyint','currencyint');
--select create_tagged_operator( 'currencyint','-','currencyint','currencyint');

--select create_tagged_operator( 'currencyfloat','*','float'        ,'currencyfloat');
--select create_tagged_operator( 'float',        '*','currencyfloat','currencyfloat');
--select create_tagged_operator( 'currencyfloat','/','currencyfloat','float'        );
--select create_tagged_operator( 'currencyfloat','+','currencyfloat','currencyfloat');
--select create_tagged_operator( 'currencyfloat','-','currencyfloat','currencyfloat');

set client_min_messages = notice;

select tag(c1), sum( value(c1) ) from c group by tag(c1) order by tag(c1);
select "timestamp"(t), tag(t) from c;
select print_currency(c1), currency( value(c2), tag(c3) ) from c where value(c1) > 5;
select a.c1*5, b.c1/5, a.c1+b.c1, a.c1-b.c1 from c a, c b where tag(a.c1) = tag(b.c1);
