set client_min_messages = fatal;

set search_path = taggedtypes, public;

set client_encoding=latin9;

DROP TABLE locales CASCADE;
CREATE TABLE locales (tag text) WITH OIDS;
DROP TABLE locale_test;

set client_min_messages = error;

copy locales from stdin;
en_US
C
POSIX
nl_NL
en_AU
\.

SELECT create_tagged_type( 'locale_text', 'text', 'locales' );

CREATE TABLE locale_test ( strings text );

copy locale_test from stdin;
test1
Test2
Tst1
tst2
Tst1
\.

create function locale_text_comp(text, text, text) returns int4 as '$libdir/taggedtypes.so' language c strict immutable;
create function locale_tt_text_comp(locale_text,locale_text) returns int4 as '$libdir/taggedtypes.so' language c strict immutable;
create function locale_text_lt(locale_text,locale_text) returns bool as 'select locale_tt_text_comp($1,$2) < 0' language sql strict immutable;
create function locale_text_le(locale_text,locale_text) returns bool as 'select locale_tt_text_comp($1,$2) <= 0' language sql strict immutable;
create function locale_text_eq(locale_text,locale_text) returns bool as 'select locale_tt_text_comp($1,$2) = 0' language sql strict immutable;
create function locale_text_ge(locale_text,locale_text) returns bool as 'select locale_tt_text_comp($1,$2) >= 0' language sql strict immutable;
create function locale_text_gt(locale_text,locale_text) returns bool as 'select locale_tt_text_comp($1,$2) > 0' language sql strict immutable;

create operator < ( procedure = locale_text_lt, leftarg = locale_text, rightarg = locale_text);
create operator <=( procedure = locale_text_le, leftarg = locale_text, rightarg = locale_text);
create operator = ( procedure = locale_text_eq, leftarg = locale_text, rightarg = locale_text);
create operator >=( procedure = locale_text_ge, leftarg = locale_text, rightarg = locale_text);
create operator > ( procedure = locale_text_gt, leftarg = locale_text, rightarg = locale_text);

CREATE OPERATOR CLASS locale_text_ops
   DEFAULT FOR TYPE locale_text USING btree AS
        OPERATOR        1       < ,
        OPERATOR        2       <= ,
        OPERATOR        3       = ,
        OPERATOR        4       >= ,
        OPERATOR        5       > ,
        FUNCTION        1       locale_tt_text_comp(locale_text,locale_text);

set client_min_messages = notice;

select strings from locale_test order by locale_text( strings, 'en_AU' );
select strings from locale_test order by locale_text( strings, 'C' );
select strings from locale_test order by locale_text( strings, 'en_US' );
