#include "utils/lsyscache.h"   // for get_func_signature and get_func_rettype
#include "catalog/catversion.h"  // Need catalog version below

#define MAX_TAG_LEN        32

struct TaggedTypeInfo;  /* Opaque for users */
struct TaggedOperatorInfo;

Datum ComposeTaggedType( struct TaggedTypeInfo *tti, Datum datum, Oid tagoid );
Oid ExtractTaggedTypeOid( struct TaggedTypeInfo *tti, Datum datum );
Datum ExtractTaggedTypeDatum( struct TaggedTypeInfo *tti, Datum datum );
struct TaggedTypeInfo *GetTaggedTypeDetails( Oid typeoid );
struct TaggedOperatorInfo *GetTaggedOperatorDetails( Oid operfuncoid );
Oid FindTagByName( struct TaggedTypeInfo *tti, text *tag_text );
text * FindTagByOid( struct TaggedTypeInfo *tti, Oid tagoid );

// Utility functions for determining the type to use
// For situations where fmgr doesn't pass you your argument types
static inline Oid
procLookupRettype( Oid procoid )
{
	return get_func_rettype( procoid );
}

static inline Oid
procLookupArgType( Oid procoid, int argno )
{
// get_func_signature was introduced in lsyscache.h v1.76 (2003/07/01)
// prototype changed in v1.95 (2005/03/29)
#if CATALOG_VERSION_NO < 200503290
	Oid	args[FUNC_MAX_ARGS];
	int	nargs;
	
	get_func_signature( procoid, args, &nargs );
#else
	Oid	*args;
	int	nargs;
	
	get_func_signature( procoid, &args, &nargs );
#endif
	return args[argno];
}

