// General socket functions
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <signal.h>

#include "qipx.h"

extern FILE *messagefile;
extern int messagelevel;
extern char *ProgramName;
extern char RealProgramName[];
extern int otherpid;

// Opens an IPX socket at the specified port
int openipxsocket(int port)
{
  int sock;
  struct sockaddr_ipx addr;
  int addrlen;
  
  Check(sock = socket(AF_IPX,SOCK_DGRAM,AF_IPX),"IPX Socket");
  
  addr.sipx_family = AF_IPX;
  addr.sipx_port = htons(port);
  addr.sipx_network = 0;
  addr.sipx_type = 17;
  addrlen = sizeof(addr);
  
  Check(bind(sock,(struct sockaddr*)&addr,addrlen),"IPX Bind");
  
  return sock;
}

int openudpsocket2(int port, int address)
{
  int sock;
  struct protoent *udp_proto = getprotobyname("udp");
  struct sockaddr_in addr;
  int addrlen;
  
  if(!udp_proto)
  { 
    printf("Couldn't get proto 'udp'\n");
    exit(0);
  }
  
  Check(sock = socket(AF_INET,SOCK_DGRAM,udp_proto->p_proto),"UDP Socket");
  
  addr.sin_family = AF_INET;
  addr.sin_port = htons(port);
  addr.sin_addr.s_addr = htonl(address);
  addrlen = sizeof(addr);
  
  Check(bind(sock,(struct sockaddr*)&addr,addrlen),"UDP Bind");
  
  return sock;
}

char *PrintIPXaddress(struct sockaddr_ipx* addr)
{
  static char buffer[64];
  
  sprintf(buffer,"%08lx:%02x%02x%02x%02x%02x%02x:%d",
      htonl(addr->sipx_network),
      addr->sipx_node[0], addr->sipx_node[1],
      addr->sipx_node[2], addr->sipx_node[3],
      addr->sipx_node[4], addr->sipx_node[5],
      htons(addr->sipx_port));
      
  return buffer;
}

int IPXcvt(char *out, char *in)
{
  if(!isxdigit(in[0]) || !isxdigit(in[1]))
    return 0;
    
  *out = 0;
  
  if(isdigit(in[0]))
    *out = in[0] - '0';
  else
    *out = toupper(in[0]) - 'A' + 10;
    
  *out *= 16;

  if(isdigit(in[1]))
    *out += in[1] - '0';
  else
    *out += toupper(in[1]) - 'A' + 10;
    
  return 1;
}

int ParseIPXaddress(char out[6], char *string)
{
  int i;
  for(i=0;i<6 && IPXcvt(&out[i],string+2*i);i++)
    ;
  
  if(i==6)    // Success!
    return 0;

  fprintf(stderr,"Bad address '%s'\n",string);
  return 1;
}

char *PrintUDPaddress(struct sockaddr_in* addr)
{
  static char buffer[32];
  
  sprintf(buffer,"%s:%d",inet_ntoa(addr->sin_addr),htons(addr->sin_port));
  
  return buffer;
}

void message(int level, char *format, ...)
{
  va_list v;
  
  if(level > messagelevel)
    return;
  
  va_start(v,format);
  
  vfprintf(messagefile,format,v);
  
  va_end(v);
  
  fflush(messagefile);
}

void messagedump(int level, char *data, int length)
{
  char *ptr = data;
  int togo = length;
  int i;
  
  if(level > messagelevel)
    return;
  
  while(togo)
  {
    fprintf(messagefile,"%04X: ",length-togo);
    
    for(i=0;i<16;i++)
    {
      if(togo > i)
        fprintf(messagefile,"%02X ",ptr[i]);
      else
        fprintf(messagefile,"   ");
    }
    
    for(i=0;togo && i<16;togo--,ptr++,i++)
      fputc(isprint(*ptr)?*ptr:'.',messagefile);
      
    fprintf(messagefile,"\n");
  }
  
  fflush(messagefile);
}

void SetProgramName(char *format, ...)
{
  va_list v;
  char buffer[200];
  
  va_start(v,format);
 
  vsprintf(buffer,format,v);
  
  strcpy(ProgramName,buffer);
  
  va_end(v); 
}

void mysignal( int sig, SignalHandler handler )
{
  struct sigaction act = { handler };
  
  sigaction( sig, &act, NULL );
}
